% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irfBand.R
\name{irfBand}
\alias{irfBand}
\title{VAR impulse responses with error bands}
\usage{
irfBand(
  pdout,
  smat = NULL,
  nstep = 40,
  order = NULL,
  pctiles = c(5, 16, 50, 84, 95),
  whichv = NULL,
  whichs = NULL,
  main = "IRF's with bands",
  file = "IRFwBandPlot.pdf"
)
}
\arguments{
\item{pdout}{Output from postdraw.}

\item{smat}{If NULL, the transpose of \code{pdout$smat[ , , draw]} is used as
initial shocks.  Otherwise, this array is used, not transposed. Can be
a single array, which is used repeatedly.}

\item{nstep}{Number of steps ahead to calculate responses.}

\item{order}{If non-null, use triangular orthogonalization with this ordering of shocks.}

\item{pctiles}{At what percentiles to draw bands. (vector of odd length)}

\item{whichv}{logical or numeric vector picking which variables' responses are calculated}

\item{whichs}{logical or numeric vector picking which shocks' effects are calculated}

\item{main}{Character string giving plot title.}

\item{file}{Character string giving name of pdf file to be written.}
}
\value{
nvar x nshocks x nstep x ndraw array of impulse responses.  Returned value is not printed, but can be assigned if you want to keep it.
}
\description{
Uses output from \code{postdraw} to construct impulse responses with error bands.
The return value is a large array, giving all the sampled forecasts, unsorted.
If a triangular ordering other than the most common one (first shock affects all
variables, last only itself) is desired, or if this is a structural VAR, the
pdout$smat array must be modified accordingly before this program is called.
}
