% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVARpostdraw.R
\name{SVARpostdraw}
\alias{SVARpostdraw}
\title{Structural VAR full posterior draws}
\usage{
SVARpostdraw(
  Adraws,
  lmddraws,
  data = NULL,
  xdata = NULL,
  nLags = 5,
  Tsigbrk = NULL,
  const = TRUE,
  pparams = list(asig = 1, mnprior = list(tight = 1, decay = 0.3), urprior =
    list(lambda = 5, mu = 1), vprior = list(sig = rep(0.01, 4), w = 1)),
  horiz = 40
)
}
\arguments{
\item{Adraws}{ndraw by nvar by nvar array of draws of $A$}

\item{lmddraws}{ndraw by nvar by nsig array of \code{lambda} draws}

\item{data}{Matrix of endogenous variable data time series}

\item{xdata}{Exogenous variable data matrix.}

\item{Tsigbrk}{Vector of observation numbers of last observation in each
variance regime.  It starts at 0, does not include end of sample. Its
length is the number of regimes.}

\item{const}{If TRUE, \code{xdata} does not include a constant and a constant
vector should be created.}

\item{pparams}{list that contains \code{asig} and the VAR prior parameters. See
help for \code{\link[=SVARhtskdmdd]{SVARhtskdmdd()}} and the details section here for
VAR prior parameters.  \code{asig} is the weight on the A0 prior.}

\item{horiz}{The number of periods over which to compute impulse responses.}

\item{nlags}{number of lags in the model}
}
\value{
\item{irf}{nvar x nvar x horiz x ndraw array of impulse responses}
\item{By}{nvar x nvar x nlags x ndraw array of  reduced form VAR coefficients}
\item{Bx}{nvar x nx x ndraw array of reduced form VAR exogenous, then
constant, coefficients.  (Just constants when there are no x's)}
\item{A}{nvar x nvar x ndraw array of A0 draws}
\item{lmd}{nvar x nsig x ndraw array of lmd draws}
}
\description{
From draws of \code{A} and \code{lambda}, generate draws of impulse response functions
and all AR coefficients
}
\details{
Takes as input draws from the marginal on the contemporaneous coefficient
matrix \code{A} and the relative variances \code{lambda} across time blocks.  Returns
draws from the coefficients on lags and the impulse response function,
conditional on the corresponding \code{A} and \code{lambda} draws.

The \code{asig} parameter scales the prior on \code{A0}, but \code{A0} always has a scaled
identity matrix as its mean.  With \code{asig=1}, all elements of \code{A0} have
std deviation 200, implying residual variances averaging around 50 basis
points.

Why are \code{A} and \code{lmd} drawn outside this program?  They have to be drawn with
an MCMC chain, which may require large numbers of draws to converge.  Drawing
irf's each time \code{A} and \code{lmd} are drawn in the chain would slow the chain
considerably.  Usually the \code{Adraws} and \code{lmddraws} for this program are a
thinning, down to say 1000 draws, of the original  \code{A} and \code{lmd} chain of
draws.

Note that to get structural irf's from the output of SVARpostdraw, The \code{smat}
argument of \verb{irfBand must be an array containing the inverses of the arrays in the }A` returned value from this program.

`pparam' is a list with elements
\itemize{
\item \code{asig}: weight on the \code{A0} prior
\item \code{urprior}: list with elements \code{lambda} and \code{mu}, which are weights on
the single "peristence dummy" and the variable-by-variable
unit root dummy, respectively
\item \code{mnprior}: list with elements \code{tight} and \code{decay} that are the overall
tightness of the Minnesota prior and the rate at which prior
standard errors of coefficients shrink with lags, respectively
\item \code{vprior}:  list with elements \code{sig} and \code{w}.  \code{sig} is a vector giving
the prior expectation of the standard deviations of the variable
innovations.  \strong{This is required, with no default.}
}
}
