% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVARhtskdmdd.R
\name{SVARhtskdmdd}
\alias{SVARhtskdmdd}
\title{Structural VAR estimation}
\usage{
SVARhtskdmdd(
  ydata,
  lags,
  xdata = NULL,
  const = TRUE,
  A0,
  lmd,
  Tsigbrk,
  breaks = NULL,
  urprior = list(lambda = 5, mu = 1),
  mnprior = list(tight = 3, decay = 0.5),
  vprior = list(sig = NULL, w = 1),
  train = 0,
  flat = FALSE,
  nonorm = FALSE,
  ic = NULL,
  nstat
)
}
\arguments{
\item{ydata}{endogenous variable data matrix, including initial condition dates.}

\item{xdata}{exogenous variable data matrix, including initial condition dates.}

\item{const}{Constant term is added automatically if const=TRUE.}

\item{A0}{Contemporaneous coefficient matrix --- constant.}

\item{lmd}{Column Vectors of -log variances of structural shocks.}

\item{Tsigbrk}{Dates at which lmd vectors change.  Last date with old lmd (not first
with new).}

\item{breaks}{breaks in the data.  The first lags data points after a break are used
as new initial conditions, not data points for the fit.
\code{lambda > 0} => x variables included; \verb{lambda < 0 =>} x variables excluded;}

\item{urprior}{list with elements
* lambda: weight on prior pulling toward either non-stationarity or
else constant consistent with steady-state mean
* mu: weight on prior pulling toward variable-by-variable random
walk behavior}

\item{mnprior}{list with Minnesota prior parameters:
* \code{tight} Overall tightness of Minnesota prior. \verb{1/tight ~} own lag
std dev
* decay Standard deviations of lags shrink as \code{lag^(-decay)}.}

\item{vprior}{list with covariance matrix prior parameters:
* sig: Vector of prior modes for square roots of diagonal elements of
r.f. covariance matrix
* w: Weight on prior on vcv.  1 corresponds to "one dummy observation"
weight}

\item{train}{If non-zero, this is the point in the sample at which the
"training sample" ends.}

\item{flat}{Even with \code{lambda=mu=vprior$w=0}, \code{mnprior=NULL},
\code{det(Sigma)^(-(nv+1)/2)} is used as a "prior", unless \code{flat=TRUE}.
\code{flat=TRUE} is likely not to work unless \code{train} is reasonably large.}

\item{nonorm}{If TRUE, use dummy observations but do not normalize posterior to make
them a proper prior.  Useful to duplicate results obtained by others,
to use dummy observations that do not imply a proper prior, or to save
computing time in case only the posterior on this model's parameters,
not the weight on the model, is needed.}

\item{ic}{Initial conditions matrix for use in forming the sums of coefficients
dummy observations.
If \code{ic=NULL}, the means of the first lags observations in \code{ydata} are
used.  If \code{!is.null(ic)}, \code{ic} should be a single "observation" on the
y's and x's that will be used as the persistent values entering the
sums of coefficients dummies.}

\item{nstat}{Logical vector.  TRUE (the default) for any variable that is
persistent, FALSE for non-persistent variables.  Determines prior
mean of first own lag coeffcient.}
}
\value{
\itemize{
\item \code{w}: Marginal posterior density for \code{A0}, \code{lmd}, with \verb{A+} integrated out.
\item \code{var}: Output of \code{rfvar3()} for full sample, including dummy observations.
\item \code{varp}: output of \code{rfvar3()} on prior dummy observations only.
\item \code{prior}:  list of prior parameter values
}
}
\description{
The posterior integrated over A+ (the right-hand side coefficients), conditional
on A0 and lmd.
}
\details{
The model is \deqn{A(L)y(t) = \varepsilon(t),} with \eqn{\varepsilon(t)}
having a diagonal covariance matrix that varies over time.  The variances change
at the dates in  \verb{Tsigbreak', and their relative sizes are in the }lmd' matrix.

vprior$sig is needed to scale the Minnesota prior, even if the prior on sigma is not
used itself.  Set vprior$w=0 to achieve this.

mnprior and vprior.w can each be set to NULL, thereby eliminating the corresponding
dummy observations.

Prior x likelihood to \code{train} is weighted to integrate to 1, and therefore is treated
as if it were itself the prior. To do a pure training sample prior, set \code{lambda=mu=0},
\code{mnprior=NULL}, \code{vprior$w=0}, \code{train > lags}.

Note that to enter a prior directly as dummy observations, one can treat the
Dummy observations as a training sample.
}
