% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csminit.R
\name{csminit}
\alias{csminit}
\title{One iteration of minimization}
\usage{
csminit(fcn, x0, f0, g0, badg, H0, Verbose, ...)
}
\arguments{
\item{fcn}{Function that evaluates objective function}

\item{x0}{starting point of iteration}

\item{f0}{function value at start of iteration}

\item{g0}{gradient from previous iteration}

\item{badg}{indicator for whether gradient is problematic}

\item{H0}{inverse Hessian approximation at the start of iteration}

\item{Verbose}{Print out each iteration of step length change?}
}
\value{
\item{fhat}{New function value}

        \item{xhat}{New x value}

        \item{fcount}{Function evaluation count}

        \item{retcode}{return code (see Details)}
}
\description{
Computes step direction and adjusts step length to achieve target rate of decrease, with
various attempts to recover if this doesn't work out.  Used by \code{csminwel()}
}
\details{
{ Meaning of \code{retcode} values: 0, normal step.  5, largest step still
improves too fast. 4,2 back and forth adjustment of stepsize didn't finish.
3, smallest stepsize still improves too slow.  6, no improvement found.
7, possible bad H matrix.  1, zero gradient.}
}
