% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgnldnsty.R
\name{mgnldnsty}
\alias{mgnldnsty}
\title{Marginal density}
\usage{
mgnldnsty(
  ydata,
  lags,
  xdata = NULL,
  const = TRUE,
  breaks = NULL,
  lambda = 5,
  mu = 1,
  mnprior = list(tight = 3, decay = 0.5),
  vprior = list(sig = NULL, w = 1),
  train = 0,
  flat = FALSE,
  nonorm = FALSE,
  ic = NULL
)
}
\arguments{
\item{ydata}{Endogenous variable data matrix, including initial condition
dates.}

\item{xdata}{Exogenous variable data matrix, including initial condition
dates.}

\item{const}{Create constant term (with no need for column of ones in
\code{xdata})?}

\item{breaks}{Breaks in the data.}

\item{lambda}{Weight on the co-persistence prior dummy observation.}

\item{mu}{Weight on variable-by-variable sum of coeffs dummy obs.}

\item{mnprior}{Parameters of individual-parameter Minnesota prior.}

\item{vprior}{Parameters of prior on shock variances}

\item{train}{If non-zero, point in the sample where the training sample ends.}

\item{flat}{Omit conventional uninformative prior on \code{Sigma}?}

\item{nonorm}{Use dummy observations but do not normalize posterior to make
them a proper prior?}

\item{ic}{If non-null, do not use initial conditions from \code{ydata} in
forming the prior.  Use \code{ic} instead.}
}
\value{
\item{w}{Log of integrated posterior}
       \item{var}{\code{rfvar} return list using all observations,
       including dummies}
      \item{varp}{\code{rfvar} return list using only dummy observations.}
      \item{prior}{list of prior hyperparameter settings used}
      \item{wp}{Log of integrated density for dummy observations; scale
        factor to convert them to proper prior.}
      \item{call}{The function call invoking this function to produce
        this result}
}
\description{
Find the log marginal data density of a VAR system
}
\details{
Note that to enter a prior directly as dummy observations, one
can treat the dummy observations as a training sample.
\subsection{breaks}{The first \code{lags} data points after a break
          are used as new initial conditions, not data points for the fit.}
\subsection{lambda}{\code{lambda>0} implies \code{x} variables included in the
     dummy observation; \code{lambda<0} => \code{x} variables excluded. Large
     \code{lambda} implies no-change forecasts are good when all variables
      have been constant.}
\subsection{mu}{Expresses belief that when y_i has shown a persistent
    deviation over \code{lags} past periods and other variables have
    not deviated, the deviation in y_i will tend to persist.
    There is one of these dummy observations for each variable.}
\subsection{mnprior$tight}{weight on the Minnesota prior dummies.  Prior std
     dev on first lag is \code{1/tight}}
\subsection{mnprior$decay}{Prior std deviation of coefficients decline with
     lag \code{j} as \code{1/j^decay}}
\subsection{vprior$sigma}{vector of scales of residual std deviations. Even
      if the prior on variances is not used (\code{w=0}), this is needed for
      construction of the rest of the prior.}
\subsection{vprior$w}{Weight on prior dummy observations asserting residual
     variances match \code{vprior$sigma}.}
\subsection{train}{ Prior times likelihood to this point in the sample is
    weighted to integrate to 1, and therefore is treated as if it were itself
    the prior. To do a pure training sample prior, set
     \code{lambda=mu=0, mnprior=NULL, vprior$w=0, train>lags.}}
\subsection{nonorm}{Useful to duplicate results obtained by others, to use
    dummy observations that do not imply a proper prior, or to save computing
      time in case only the posterior on this models parameters, not the
      weight on the model, is needed.}
}
