% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcastBand.R
\name{fcastBand}
\alias{fcastBand}
\title{VAR forecasts with error bands}
\usage{
fcastBand(
  pdout,
  y0,
  horiz = 40,
  pctiles = c(5, 16, 50, 84, 95),
  whichv = NULL,
  whichs = NULL,
  main = "Forecasts with bands",
  file = "FcastBandPlot.pdf",
  xdata = NULL
)
}
\arguments{
\item{pdout}{Output from postdraw.}

\item{y0}{Initial conditions for forecast. Its tsp() is used, if present.}

\item{pctiles}{At what percentiles to draw bands. (vector of odd length)}

\item{whichv}{logical or numeric vector picking which variables' responses are calculated}

\item{whichs}{logical or numeric vector picking which shocks' effects are included.
Can be 0 if bands reflecting only uncertainty from parameter estimates
are desired.  whichs or whichv set to NULL means all are used.}

\item{main}{Character string giving plot title.}

\item{file}{Character string giving name of pdf file to be written.}

\item{xdata}{(lags + horiz) x nx matrix of exogenous variable values, not including the
constant if \code{const=TRUE)}.}

\item{nstep}{Number of steps ahead to calculate forecasts.}
}
\value{
nvar x nstep x ndraw array of forecasts.  Returned value is not printed,
but can be assigned if you want to keep it.
}
\description{
Uses output from \code{postdraw} to construct forecasts with error bands.
The return value is a large array, giving all the sampled forecasts, unsorted..
}
