% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfvar3.R
\name{rfvar3}
\alias{rfvar3}
\title{Reduced form VAR estimation}
\usage{
rfvar3(
  ydata = NA,
  lags = 6,
  xdata = NULL,
  const = TRUE,
  breaks = NULL,
  lambda = 5,
  mu = 2,
  ic = NULL,
  sigpar = NULL
)
}
\arguments{
\item{ydata}{T x nvar dependent variable data matrix.}

\item{lags}{number of lags in the VAR}

\item{xdata}{T x nx exogenous variable data matrix.}

\item{const}{Automatically generate a constant vector?}

\item{breaks}{Column vector of row numbers in ydata and xdata after which
there is a break.}

\item{lambda}{Weight on "co-persistence" dummy observations.}

\item{mu}{Weight on "own persistence" dummy observations.}

\item{ic}{If non-null, do not use initial conditions from \code{ydata} in
forming the prior.  Use \code{ic} instead.}

\item{sigpar}{\code{list(A0, lmd, Tsigbrk)} When non-null, allows SVAR with
time varying shock variances.  See Details.}
}
\value{
\item{By}{nvar x nvar x lags matrix of coefficients on lagged ys.
    1st dimension is equation number}
   \item{Bx}{nvar x nx matrix of coefficients on x}
   \item{u}{\code{T-lags + (number of dummy obs)} by \code{nvar} matrix of
      residuals. If \code{ydata} is a ts object, \code{u} will be also, and will
       be correctly dated.  \code{u} observations dated after
       \code{end(ydata)} are dummy observations.}
   \item{uraw}{Unweighted reduced-form residuals}
   \item{xxi}{\code{crossprod(X)} inverse, same for all equations.  With
      \code{sigpar==NULL}, \code{kronecker(cov(u),xxi)} is the full
      covariance matrix of the regression coefficients.}
   \item{snglty}{ Usually 0.  If the rhs variable matrix is not full column
      rank, this is the gap between the number of columns and the
      number of non-zero singular values.
}
}
\description{
Estimates vector autoregression, with time varying covariance matrix option.
}
\details{
This algorithm goes for accuracy without worrying about memory requirements.
The standard prior it implements is NOT APPROPRIATE for seasonally
unadjusted data, even if seasonal dummies are included in xdata.  The prior
shrinks toward simple persistence, so it will tend to prevent the dummies
from picking up all the seasonality.

\subsection{breaks}{The first \code{lags} data points after a break.
          are used as new initial conditions, not data points for the fit.
          This allows for discontinuities in the data (e.g. war years, panel
          data) and for the possibility of adding dummy observations to
          implement a prior.}
\subsection{lambda}{\code{lambda>0} implies \code{x} variables included in the
     dummy observation; \code{lambda<0} => \code{x} variables excluded. Large
     \code{lambda} implies no-change forecasts are good when all variables
     have been constant.}
\subsection{mu}{Expresses belief that when y_i has shown a persistent
    deviation over \code{lags} past periods and other variables have
    not deviated, the deviation in y_i will tend to persist.
    There is one of these dummy observations for each variable.}
\subsection{sigpar}{ \code{A0}: constant matrix such that \code{A0 \% * \% u},
    where \code{u} is the reduced form VAR residual, has a diagonal covariance
    matrix.

    \code{lmd}: nvar by m matrix with columns standard deviations of
        \code{e=A0 \% * \% u}

    \code{Tsigbrk}: vector of observation numbers after which the model
         switches to the next column of \code{lmd}.
}
}
