% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrictint.R
\name{matrictint}
\alias{matrictint}
\title{Matrix t integral}
\usage{
matrictint(S = NULL, XXi, T, cx = NULL, cs = NULL)
}
\arguments{
\item{S}{usually sample cross product matrix of LS residuals}

\item{T}{number of observations}

\item{cx}{instead of XXi, can provide UT cx}

\item{cs}{Upper triangular Cholesky factor of sample crossproduct of residuals}

\item{XXI}{inv(X'X) matrix for rhs variables}
}
\description{
Integrates the posterior of an SUR or VAR system
}
\details{
Provides the log of the integrated posterior for SUR or RF VAR with
\code{det(Sigma)^(-(m+1)/2)} Jeffreys-like prior. To get the log of the integral of the
likelihood for a VAR with \code{T} observations, \code{k} rhs variables in each equation,
and \code{m} equations, set \code{T=T-m-1} and subtract \code{.5*m*(m+1)*log(2*pi)}.
We are integrating the exponential of
\deqn{-.5Tm\log(2*\pi)-.5(T+m+1)\log(det(\Sigma))-.5trace(\Sigma^{-1}S(\beta)).}
}
