% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histDecomp.R
\name{histDecomp}
\alias{histDecomp}
\title{Historical variance decomposition}
\usage{
histDecomp(vout, vts, xdata = NULL, const = TRUE, orthmat = NULL)
}
\arguments{
\item{vout}{List in format of \code{\link[=rfvar3]{rfvar3()}} output.}

\item{vts}{The time series data to be decomposed; usually the data used to
estimate \code{vout}. Must be a \code{ts} object.}

\item{xdata}{Exogenous variable data.}

\item{const}{If TRUE, constant vector is generated, not supplied in \code{xdata}.}

\item{orthmat}{NULL is equivalent to \code{orthmat=chol(var(u))}, i.e. triangular
orthogonalization.  Otherwise should satisfy
\code{crossprod(orthmat)==var(u)}}
}
\value{
\itemize{
\item \code{ydec}: nv by nv+1 by T array historical decomposition. \verb{[ , nv+1, ]}
component is the deterministic part
\item \code{ydecStack}: Cumulated sum of \code{ydec}, along the shock dimension.  Helpful
to form a single "stacked" plot adding up to the actual.
}
}
\description{
Allocates historical time series to VAR shocks that explain them
}
