% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bvarwrapEx.R
\name{bvarwrapEx}
\alias{bvarwrapEx}
\title{log posterior for SVAR with time series ID through heteroskedasticty}
\usage{
bvarwrapEx(
  x,
  verbose = FALSE,
  data = NULL,
  nLags = 5,
  Tsigbrk = NULL,
  pparams = list(asig = 1, mnprior = list(tight = 1, decay = 0.3), urprior = list(lambda
    = 5, mu = 1))
)
}
\arguments{
\item{x}{vector with all elements of A0, Lambda}

\item{verbose}{flag of whether to report more than the negative LLH. FALSE
is useful for extracting results after iterations are complete.}

\item{data}{A mts object with the data.}

\item{nLags}{Number of lags.}

\item{Tsigbrk}{Vector of observation numbers of last observation in each
variance regime.  It starts at 0, does not include end of sample. Its
length is the number of regimes}

\item{pparams}{list that contains \code{asig} and the VAR prior parameters. See
help for \code{\link[=SVARhtskdmdd]{SVARhtskdmdd()}} and the details section here for
VAR prior parameters.  \code{asig} is the weight on the A0 prior.}
}
\value{
\itemize{
\item \code{lh}: Minus log posterior density. If \code{verbose==FALSE}, only this is returned
\item \code{vout}: output from \code{SVARhtskdmdd()}
\item \code{A}: Matrix of contemporaneous coefficients on \eqn{y}.
\item \code{lambda}: Matrix of relative variances of residuals in each regime.
\item \code{llmd}:  \code{-log(lmd)}
\item \code{ustd}:  GLS residuals, which should be close to N(0,1).
\item \code{u}: Reduced form residuals (variable innovations)
\item \code{asig}: \code{pparam$asig}, scale factor for A0 prior sd.
\item \code{lplmd}: log lh from lmd prior
\item \code{allh}: log lh from A0 prior
}
}
\description{
Variances of structural shocks change at pre-specified break dates.
}
\details{
The \code{asig} parameter scales the prior on \code{A0}, but \code{A0} always has the
identity matrix as its mean.  With \code{asig=1}, all elements of \code{A0} have
std deviation 200, implying residual variances averaging around 50 basis
points.

`pparam' is a list with elements
\itemize{
\item \code{asig}: weight on the \code{A0} prior
\item \code{urprior}: list with elements \code{lambda} and \code{mu}, which are weights on
the single "peristence dummy" and the variable-by-variable
unit root dummy, respectively
\item \code{mnprior}: list with elements \code{tight} and \code{decay} that are the overall
tightness of the Minnesota prior and the rate at which prior
standard errors of coefficients shrink with lags, respectively
\item \code{vprior}:  list with elements \code{sig} and \code{w}.  \code{sig} is a vector giving
the prior expectation of the standard deviations of the variable
innovations.  \strong{This is required, with no default.}
}

\code{Tsigbrk} can be formed in an external program by using \code{\link[=invTime]{invTime()}} to
transform ts-object-format dates into observation numbers.  Since this
program is called repeatedly, it does not make sense to do this translation
each time this program is invoked.
}
\section{Bugs}{

Should be modified to allow pass-through of \code{nstat} parameter of prior.
This requires changes in \code{SVARhtskdmdd()} also.
}

