SVARpostdraw <- function(Adraws, lmddraws, data = NULL, xdata=NULL, nLags = 5, Tsigbrk = NULL,
                         const=TRUE,
                         pparams = list(
                             asig=1,
                             mnprior=list(tight=1, decay=.3),
                             urprior=list(lambda=5, mu=1),
                             vprior=list(sig=rep(.01,4), w=1)), horiz=40) {
    ndraw <- dim(Adraws)[1]
    nvar <- dim(Adraws)[2]
    nsig <- dim(lmddraws)[3]
    cnstAdd <- if(const) 1 else 0
    if (is.null(xdata)) {
        nx <- cnstAdd
    } else {
        nx <- dim(xdata)[2] + cnstAdd
    }
    nyx <- nvar * nLags + nx
    Bydraw <- array(0, c(nvar, nvar, nLags, ndraw))
    Bxdraw <- array(0, c(nvar, nx, ndraw))
    irfdraw <- array(0, c(nvar, nvar, horiz, ndraw))
    for (id in 1:ndraw) {
        A <- Adraws[id, , ]
        Ai <- solve(A)
        x <- c(A, lmddraws[ id , , -nsig ])
        bvwout <- bvarwrapEx(x, verbose=TRUE, data=data,
                             nLags=nLags, Tsigbrk=Tsigbrk, pparams=pparams)
        xxi <- bvwout$vout$var$xxi
        ## This is weighted x'x for each of the nvar equations.
        ## xxch <- apply(xxi, 3, chol) # this creates numerical problems
        Aplus <- matrix(0, nvar, nyx)
        for (iq in 1:nvar) {
            svdxx <- svd(xxi[ , , iq])
            xxch <- with(svdxx, t(sqrt(d) * t(u)))                      
            xxch <- array(xxch, c(nyx, nyx, nvar))
            Aplus[iq, ] <- xxch[ , , iq] %*% rnorm(nyx) +
                + c(bvwout$vout$var$By[iq, , ],  bvwout$vout$var$Bx[iq, ])
        }
        Byx <- Ai %*% Aplus
        By <- array(Byx[ , 1:(nvar * nLags)], c(nvar, nvar, nLags))
        Bydraw[ , , , id] <- By
        Bxdraw[ , , id] <- Byx[ , nvar * nLags + 1:nx, drop=FALSE] # constant is at end
        irfdraw[ , , , id] <- impulsdtrf(vout=list(By=By), smat=Ai, nstep=horiz)
    }
        return(list(irf=irfdraw, By=Bydraw, Bx=Bxdraw, A=Adraws, lmd=lmddraws))
}


    
    
