% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varprior.R
\name{varprior}
\alias{varprior}
\title{Minnesota prior}
\usage{
varprior(nv = 1, nx = 0, lags = 1, mnprior = list(tight = 5, decay =
  0.5), vprior = list(sig = 1, w = 1), urprior = list(lambda = NULL, mu =
  NULL), xsig = NULL, ybar = NULL, xbar = 1, nstat = rep(TRUE, nv))
}
\arguments{
\item{nv}{number of endogenous variables}

\item{nx}{number of exogenous variables}

\item{lags}{number of lags}

\item{mnprior}{list of individual-coefficient prior hyperparmaters}

\item{vprior}{list of scale factors and weight on shock size priors}

\item{urprior}{list of hyperparameters for unit root and cointegration prior}

\item{xsig}{rough scale of \code{x} variables}

\item{ybar}{scale of persistence dummy observations}

\item{xbar}{scale of persistence dummy observation \code{x} values}

\item{nstat}{where \code{TRUE}, the variable is persistent}
}
\value{
\item{ydum}{dummy observations on y}
        \item{xdum}{dummy observations on x}
        \item{pbreaks}{locations of breaks in the dummy observations}
}
\description{
Generates dummy observations for a Minnesoat prior on a VAR
}
\details{
Output of this function is used in \code{\link{mgnldnsty}}, and can
be used with \code{\link{rfvar3}}.
\subsection{mnprior$tight}{weight on the Minnesota prior dummies.  Prior std
     dev on first lag is \code{1/tight}}
\subsection{mnprior$decay}{Prior std deviation of coefficients decline with
     lag \code{j} as \code{1/j^decay}}
\subsection{vprior$sigma}{vector of scales of residual std deviations. Even
      if the prior on variances is not used (\code{w=0}), this is needed for
      construction of the rest of the prior.}
\subsection{vprior$w}{Weight on prior dummy observations asserting residual
      variances match \code{vprior$sigma}.}
\subsection{urprior}{For \code{urprior} hyperparameters see
\code{\link{rfvar3}}.  The elements of either \code{urprior} or
\code{mnprior} can be set to \code{NULL}, eliminating the corresponding dummy
observations, and the elements of \code{urprior} must be set to \code{NULL}
if the output is to be used in \code{rfvar3} with non-null \code{lambda,mu}
there.}
}
