% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotir.R
\name{plotir}
\alias{plotir}
\title{Impulse response plots}
\usage{
plotir(resp, var = NULL, shock = NULL, type = c("multiple", "single"),
  main = "Impulse response plot", yax.flip = TRUE, vfirst = TRUE,
  file = "irplot.pdf")
}
\arguments{
\item{resp}{3-d or 4-d array of impulse responses.}

\item{var}{Indexes of variables to be plotted, if not all of them.}

\item{shock}{Indexes of shocks to be plotted, if not all of them.}

\item{type}{"multiple" creates an array of plots. "single" puts them
all on same plot (usually responses of just one variable).
(Curent version ignores this argument, always assumes "multiple".)}

\item{main}{Title for plot.}

\item{yax.flip}{Alternate sides of small plots on which y-axis labels appear?}

\item{vfirst}{Variables vary by row? Otherwise shocks do.}

\item{file}{Name for output pdf file.}
}
\description{
Plots an array of impulse response graphs.
}
\details{
The rows and columns are labeled.  Responses of the same variable
have the same scale. The responses can either
be a 3-d array as emerges from \code{impulsdtrf}, or a 4-d array that
collects several such 3-d arrays, to allow plotting of error bands. Output
is sent to a pdf file as well as to the screen.
}
