% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ksmooth.R
\name{ksmooth}
\alias{ksmooth}
\title{Kalman smoother}
\usage{
ksmooth(btt, Stt, bnT, SnT, A, omega)
}
\arguments{
\item{btt}{Mean of state at t, given information up to t, from KF}

\item{Stt}{Covariance matrix of state at t, given info up to t, from KF}

\item{bnT}{Mean of state at t+1, given full sample info, from this recursion}

\item{SnT}{Cov matrix of state at t+1, given full sample info, from this recursion}

\item{A}{Plant equation coefficient matrix}

\item{omega}{covariance matrix of plant equation disturbance}
}
\value{
\item{btT}{Mean of {bt} based on full sample}
        \item{StT}{Covariance matrix of \code{bt} based on full sample}
}
\description{
One step of the recursion, using Kalman filter output, to generate smoothed states.
}
\details{
Plant equation is \eqn{b_n = A b_t + e}{bn = A \%*\% bt + e}
}
