% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kf2.R
\name{kf2}
\alias{kf2}
\title{Kalman Filter}
\usage{
kf2(y, H, shat, sig, G, M, N = NULL)
}
\arguments{
\item{y}{The observation vector.}

\item{H}{The matrix connecting observation to state.}

\item{shat}{The prior mean for the state.}

\item{sig}{The prior covariance matrix for the state.}

\item{G}{The matrix coefficient on the past state in the plant equation.}

\item{M}{The Cholesky factor of the covariance matrix of shocks to the plant equation.}

\item{N}{The Cholesky factor of the covariance matrix of errors in the observation equation.}
}
\value{
A list with these elements:
   \describe{
       \item{\code{shat}}{new mean for the state}
       \item{\code{sig}}{new covariance matrix for the state}
       \item{\code{lh}}{length-2 vector of log likelihood elements (summing to log likelihood)}
       \item{\code{fcsterr}}{error in forecast of the observation}
  }
}
\description{
Does one step of the Kalman filter recursion
}
\details{
The model is \eqn{s = G s + t(M) e} (plant equation) and
         \eqn{y = H s + t(N) u} (observation equation). \eqn{e} and \eqn{u} are
         both \eqn{N(0,I)}.  If \eqn{N} is non-null, the returned values extend the
         state to include \eqn{t(N) u}, so if this function is being applied recursively, the
         returned shat and sig must be truncated.  It would be more efficient to
         rewrite the model with the expanded state vector (and hence null \eqn{N}).
}
