#' Source a whole directory
#'
#'@param path Path to directory.
#'@param trace List files as they are sourced?
#'@param pattern Regex pattern to select files to source.
#'
##'@export
#'
sourceDir <-
function(path, trace = TRUE, pattern = "\\.[RrSsQq]$", ...) {
  for (nm in list.files(path, pattern)) {
      if(trace) cat(nm,":",sep="")           
      source(file.path(path, nm), ...)
      if(trace) cat("\n")
  }
}
