% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/csolve.R
\name{csolve}
\alias{csolve}
\title{csolve}
\usage{
csolve(FUN, x, ..., gradfun = NULL, crit = 1e-07, itmax = 20,
  verbose = TRUE, vverbose = FALSE, alpha = 0.001, delta = 1e-06,
  long = FALSE)
}
\arguments{
\item{FUN}{A function with vector argument \code{x} or (when numerical
derivatives are used) with matrix argument \code{x}.
The number of rows in x matches the number of rows in the return
value.  For numerical derivatives, the number of columns in \code{x} is
the number of distinct argument vectors at which \code{FUN} is evaluated.}

\item{x}{initial value for FUN's argument.}

\item{...}{in this position the user can place any number of additional arguments, all
          of which are passed on to \code{FUN} and \code{gradfun} (when it is
           non-empty) as a list of arguments following \code{x}.

-------------------------------------------------------------------
          Arguments below this usually can be left at defaults.}

\item{gradfun}{The function called to evaluate the gradient matrix.  If this
is NULL (the default), a numerical gradient is used instead.  If
it is identical to \code{FUN}, then \code{FUN} returns a value \code{v}
with \code{attr(v,"grad")} the gradient matrix.}

\item{crit}{If the sum of absolute values that \code{FUN} returns is less than this,
the equation is solved.}

\item{itmax}{The solver stops when this number of iterations is reached, with \code{rc=4}}

\item{verbose}{If FALSE, the amount of output during iterations is cut to zero.}

\item{alpha}{Tolerance on rate of descent.  The algorithm may produce search
directions nearly orthogonal to the gradient, and hence nearly
zero directional derivative.  Smaller alpha allows closer
approach to orthogonality.}

\item{delta}{difference interval in (cheap, forward-difference) numerical
              derivative.  Ignored if gradfun non-NULL.}

\item{long}{Set to TRUE to suppress printout of \code{x} and \code{f} at each iteration.
    (No effect if verbose=FALSE)
Useful when x and FUN are long vectors.}
}
\value{
A list with these elements:
          \describe{
            \item{\code{x}}{solution vector}
            \item{\code{f}}{function value vector at solution}
            \item{\code{itcount}}{how many iterations did it take}
            \item{\code{retcode}}{0 means normal solution, 1 and 3 mean no
                          solution despite extremely fine adjustments
                         in step length (very likely a numerical problem,
                       or a discontinuity). 4 means \code{itmax} termination.}
         }
}
\description{
Solves a nonlinear equation system
}

