% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssSolve.R
\name{ssSolve}
\alias{ssSolve}
\title{ssSolve}
\usage{
ssSolve(
  ex,
  x0,
  param,
  crit = 1e-07,
  itmax = 20,
  verbose = TRUE,
  alpha = 0.001,
  delta = 1e-06,
  long = FALSE,
  ct = FALSE,
  xchk = function(x) TRUE
)
}
\arguments{
\item{ex}{the \code{eqsys} object}

\item{x0}{an initial guess of the steady state}

\item{crit}{size of the discrepancy in steady state equations that
is treated as effectively zero.}

\item{itmax}{maximum number of iterations of the nonlinear solver.  The
default 20 is usually enough, but up to 400 is also usually fast.}

\item{verbose}{Should the iterations of the solver be printed out in full?}

\item{alpha, delta}{See the documentation for \code{csolve()}}

\item{long}{If \code{verbose}, do not include full printout of
function and parameter value vectors.}

\item{ct}{Is model continuous time?}

\item{xchk}{An optional function of \code{x} that returns \code{FALSE} if
its argument is outside the domain of definition of \code{ex}}
}
\value{
\describe{
\item{\code{xss}}{steady state value of the variables}
\item{\code{csout}}{returned object from the nonlinear equation solver}
\item{\code{fss}}{the function, constructed from ex, that returns zero
when its argument is a steady state value}
}
}
\description{
Find the steady state of a dynamic \code{eqsys} object.
}
