% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qzswitch.R
\name{qzswitch}
\alias{qzswitch}
\title{qzswitch}
\usage{
qzswitch(i = 1, qzlist)
}
\arguments{
\item{i}{the position on the diagonal to be switched with the one below}

\item{qzlist}{the list of matrices from \code{qz}, translated to the local
list names as at the top of \code{gensys}.}
}
\value{
a list like the input, but with i and i+1 positions switched.
}
\description{
reorder adjacent eigenvalues in a qz decomposition
}
\details{
Takes U.T. matrices \code{a, b}, orthonormal matrices \code{q,z},
interchanges diagonal elements \code{i} and \code{i+1} of both
\code{a} and \code{b}, while maintaining \code{q \%*\% a \%*\% t(z)}
and \code{q \%*\% b \%*\% t(z)}
unchanged.  If diagonal elements of \code{a} and \code{b}
are zero at matching positions, the returned \code{a} will have zeros at both
positions on the diagonal.  This is natural behavior if this routine is used
to drive all zeros on the diagonal of \code{a} to the lower right, but in
this case  the qz transformation is not unique and it is not possible simply
to switch the positions of the diagonal elements of both \code{a}
and \code{b}.
}
\seealso{
\code{\link[=qzdiv]{qzdiv()}}, \code{\link[=gensys]{gensys()}}, QZ package.
}
