% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qzdivct.R
\name{qzdivct}
\alias{qzdivct}
\title{qzdivct}
\usage{
qzdivct(stake, qzlist)
}
\arguments{
\item{stake}{The value of the real part of a root above which it is
classified as explosive.}

\item{qzlist}{list of components of qz decomposition
\describe{
  \item{`a,b`}{triangular matrices}
  \item{`Q,Z`}{orthonormal matrices}
  \item{`gev`}{generalized eigenvalues}
  \item{'rc'}{The INFO value returned by the underlying LAPACK}
}}
}
\description{
Rearranges qz decomposition output to put explosive roots in lower right
}
\details{
Takes qz decomp output, rearranges a and b
so that all cases of real(b(i,i)/a(i,i))>stake are in lower right
corner, while preserving U.T. and orthonormal properties and q'az' and
q'bz'.  abs(a(i,i)) < realsmall is interpreted as a zero and as generating
an infinitely positive real part of the ratio.  All i's for which this
criterion are satisfied are grouped together in the lower right corner
of the lower right corner, with the non-zero roots above them.  This
version differs from
qzdiv in that it works on the real part's value, as is appropriate for
continuous time models, instead of on the absolute value, as is
appropriate for discrete time models.
}
