% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qzdiv.R
\name{qzdiv}
\alias{qzdiv}
\title{qzdiv}
\usage{
qzdiv(stake, qzlist, flip = FALSE)
}
\arguments{
\item{stake}{the real number about which the roots are sorted}

\item{qzlist}{the qz transform list.  The \code{qz} from the QZ package
uses different names in its output list, which have to be translated
as at the start of \code{gensys} before being passed to this program.}

\item{flip}{If \code{flip} is TRUE, then cases with
\code{abs(b[i,i]/a[i,i]) < stake} are in lower right.}
}
\value{
The input list, with all matrices re-ordered.
}
\description{
Sort the roots in a qz decomposition around a value
}
\details{
Takes a list containing matrices \code{a, b}, orthonormal
matrices \code{q,z}, and rearranges them so that all cases of
\code{abs(b[i,i] / a[i,i]) > stake} are in lower right corner, while
preserving U.T. and orthonormal properties and \code{q \%*\% a \%*\% t(z)} and
\code{q \%*\% b \%*\% t(z)}.
}
\seealso{
\link{gensys}, \link{QZ::qz}, \link{qzswitch}
}
