% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/padm.R
\name{padm}
\alias{padm}
\title{Matrix exponential}
\usage{
padm(A, p = 6)
}
\arguments{
\item{A}{Matrix argument to the exponential function}

\item{p}{The degree of the Pade approximation to the exponential function}
}
\description{
Computes the matrix exponential exp(A) using the irreducible
(p,p)-degree rational Pade approximation to the exponential function.

\deqn{E = padm( A )}
}
\references{
Roger B. Sidje (rbs@maths.uq.edu.au)
EXPOKIT: Software Package for Computing Matrix Exponentials.
ACM - \emph{Transactions On Mathematical Software}, 24(1):130-156, 1998
converted to R by Chris Sims (sims@princeton.edu)
}
\seealso{
CHBV, EXPOKIT and the MATLAB supplied functions EXPM and EXPM1.
These are FORTRAN and MATLAB functions and packages, not part of this
package.
}
