% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impulsct.R
\name{impulsct}
\alias{impulsct}
\title{Continuous time impulse responses}
\usage{
impulsct(impact, G1, interval, span)
}
\arguments{
\item{impact}{Weights on the white noise exogenous shocks. Number of variables by
number of shocks matrix.}

\item{G1}{Matrix of coefficients on the levels of the variables in the \eqn{y}
vector in the \code{ydot = G1 \%*\% y + impact \%*\% eps} form.}

\item{interval}{The time interval between the discrete values of the time index at
which the irf's are computed.}

\item{span}{The span of time over which the irf's are computed.}
}
\value{
A 3-d array, with dimensions the number of variables, the number of shocks,
and the number of points at which the irf's have been computed.
}
\description{
Generates irf's from the output of \code{gensysct()}
}
\details{
\code{impact} and \code{G1} are assumed to be of the form in the output of gensysct.R.  The total
number of points at which irf's are computed are \code{span / interval}.
}
