% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gensysct.R
\name{gensysct}
\alias{gensysct}
\title{Solve a continuous time linear rational expectations model}
\usage{
gensysct(g0, g1, c0 = rep(0, dim(g0)[1]), psi, pi, div = -1)
}
\arguments{
\item{g0}{Coefficients on Dy}

\item{g1}{Coefficients on y}

\item{c0}{Constant terms (default 0)}

\item{psi}{Coefficients on exogenous shocks}

\item{pi}{Coefficients on expectational errors}
}
\value{
\subsection{eu}{

\code{eu[1]}=(existence); \code{eu[2]}=(uniqueness). Else \code{eu==c(-2,-2)}  => indeterminacy via singularity
in the equation system.
}

\subsection{derivs}{

If >=0, the forward part of the solution involves delta functions (derivs=0) or derivatives
up to order derivs, of the expected future path of the exogenous process epsilon.  The paper cited above
explains how to derive the forward solution from this function's return values.
}

\subsection{loose}{

Indicates directions in which the model is indeterminate.
}
}
\description{
Solve a continuous time linear rational expectations model
}
\details{
System given as\preformatted{       g0 \%*\% Dy=g1 \%*\% y + c + psi \%*\% epsilon + pi \%*\% eta,
}

with epsilon an exogenous variable process and eta being endogenously determined
white noise expectational errors.  Returned system is\preformatted{     Dy =  -G1  \%*\% y + impact \%*\% epsilon + zeta ,
}

for the case where epsilon is white noise.  If epsilon is not white noise, the solution
is more complicated but can be computed from the returned qz decomposition.
If div is omitted from argument list, a div>0 is calculated.
Also returned is the qz decomposition, q'az'=g0, q'bz'=g1, with a and b
upper triangular and the system ordered so that all zeros on the diagonal of b are in
the lower right corner, all cases where the real part of bii/aii is greater than or
equal to div appear in the next block above the zeros, and the remaining bii/aii's
all have bii/aii<div .    See the paper "Solving Linear Rational Expectations Models",
\url{http://sims.princeton.edu/yftp/gensys} .
}
