% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g0g1evalc.R
\name{g0g1evalc}
\alias{g0g1evalc}
\title{Evaluate system matrices, continuous time model}
\usage{
g0g1evalc(
  dexpr,
  x,
  xd = vector("numeric", length(x)),
  shock = attr(dexpr, "shock"),
  experr = attr(dexpr, "forward"),
  param = attr(dexpr, "param")
)
}
\arguments{
\item{dexpr}{derivative expression vector, as produced by g0g1dc}

\item{x}{nx by 1 matrix of values of x, names in dimnames(x)[\link{1}]}

\item{xd}{nx by 1 matrix of values of xdot, names in dimnames(x)[\link{1}]}

\item{experr}{logical vector, TRUE at forward-looking equations' positions.}

\item{param}{vector of values of parameters (all other symbols) in the expressions}

\item{shock:}{exogenous shocks (all assumed centered at 0)}
}
\value{
\describe{
\item{\code{g0}}{Coefficients on derivatives}
\item{\code{g1}}{Coefficients on levels, on rhs}
\item{\code{Psi}}{Coefficients on shocks}
\item{\code{Pi}}{Coefficients on endogenous expectational errors}
}
}
\description{
Form numerical system matrices for continuous time linearized system
}
\details{
NB x, xd, and param must all be vectors with named components, or lists.
}
