% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g0g1eval.R
\name{g0g1eval}
\alias{g0g1eval}
\title{g0g1eval}
\usage{
g0g1eval(
  dexpr,
  x,
  xl = as.vector(x),
  shock = attr(dexpr, "shock"),
  experr = attr(dexpr, "forward"),
  param
)
}
\arguments{
\item{dexpr}{derivative expression vector, as produced by \code{g0g1d}}

\item{x}{vector of named values (not names) of \code{x}}

\item{xl}{vector of named values of \code{xl}}

\item{shock}{a vector of named values of exogenous shocks (all assumed
centered at 0)}

\item{experr}{logical vector, TRUE for equations with expectational errors}

\item{param}{vector of values of parameters (all other symbols) in
the expressions.}
}
\value{
A list for use as inputs to \code{gensys()}, with elements
  \describe{
  \item{\code{g0}}{left-hand side coefficient matrix}
  \item{\code{g1}}{right-hand side coefficient matrix}
  \item{\code{Psi}}{matrix of coefficients on exogenous shocks}
  \item{\code{Pi}}{matrix of coefficients on endogenous expectation errors}
  \item{\code{param}}{parameter vector (same as input \code{param})}
  }
}
\description{
Evaluates linearized system matrices at given parameters.
}
\details{
\code{x}, \code{xl}, and \code{param} must all be vectors with named
  components, or lists.  When \code{x} is something like \code{flmss$xss},
  where \code{flmss} is a returned value from \code{ssSolve}, the default
  assignment for \code{param} works.
}
