% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g0g1dc.R
\name{g0g1dc}
\alias{g0g1dc}
\title{Add derivative attribute to an equation system}
\usage{
g0g1dc(
  ex,
  x = attr(ex, "vlist"),
  xd = paste(x, "dot", sep = ""),
  shock = attr(ex, "shock")
)
}
\arguments{
\item{ex}{vector of expressions defining equilibrium}

\item{x}{names (character) of current value variables}

\item{xd}{time-derivative  names. By default, just x names with "dot" appended.}

\item{shock}{exogenous disturbance variable names}
}
\value{
What is returned is a list of  expressions.  When evaluated, these
expressions yield the values of the expressions in ex, but they also have "gradient" attributes, so
that attr(evaluated expression,"gradient") is the gradient vector,
or a gradient matrix if the elements of x (say) are vectors.  Note that when this routine
returns a matrix as the gradient, this is not the df/dx matrix with f the ex vector.  It is
df(ix)/dx for a particular ix, evaluated at a vector of arguments.
}
\description{
New system contains the old, but forms automatic derivatives of the system.
}
