% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g0g1d.R
\name{g0g1d}
\alias{g0g1d}
\title{g0g1d}
\usage{
g0g1d(
  ex,
  x = attr(ex, "vlist"),
  xl = paste(x, "l", sep = ""),
  shock = attr(ex, "shock")
)
}
\arguments{
\item{ex}{\code{eqsys} object --- an equation system.}

\item{x}{character vector of names of current value variables}

\item{xl}{character vector of lagged value names. By default, just \code{x}
names with "l" appended.}

\item{shock}{character vector of exogenous disturbance variable names}
}
\value{
A list of nf expressions.  When evaluated, these
expressions yield the values of the expressions in ex, but they also
have "gradient" attributes, so that
\code{attr(evaluated expression,"gradient")} is, for each of the
expressions in \code{ex},  the gradient vector for that \code{ex[[ix]]}.
}
\description{
Find analytic derivatives of an \code{eqsys} object.
}
\details{
This function produces expressions, not values.  To get numeric values for
the derivative matrices, the output from this function is handed to
\code{g0g1eval}, along with the steady state value (from \code{ssSolve()})
and parameter settings to use in doing the evaluation.
}
