#' sssysc
#'
#' make steady state \code{eqsys} object from a continuous time dynamic one
#' 
#' Transform an \code{eqsys} continuous time dynamic system to a static system for use
#' in finding the steady state, usually with \code{ssSolve()}.
#' 
#' @param eq an eqsys object with a declared vlist attribute and with
#'   derivatives denoted by "dot"'s attached to the end of the variable names.
#'   (Notice that this means that if a variable name ends in "dot", it
#'   should not be another variable name when the terminal "dot" is removed.)
#' @return A new system with all dot variable names eliminated and replaced by zeros
#'         in the equations.  
#'
#' @export
#' 
sssysc <- function(eq) {
  nq <- length(eq)
  nv <- length(attr(eq, "vlist"))
  eq2 <- eq
  for ( iv in 1:nv) {
    eq2 <- parse(text=gsub(paste("(\\b", attr(eq,"vlist")[iv], ")dot\\b", sep=""),  "0", eq2, perl=TRUE))
  }
  attributes(eq2) <- attributes(eq)
  return(eq2)
}
