#' Add derivative attribute to an equation system
#'
#' New system contains the old, but forms automatic derivatives of the system.
#'
#' 
#' @param ex     vector of expressions defining equilibrium
#' @param x      names (character) of current value variables 
#' @param xd     time-derivative  names. By default, just x names with "dot" appended.
#' @param shock  exogenous disturbance variable names
#' 
#' @return What is returned is a list of  expressions.  When evaluated, these
#' expressions yield the values of the expressions in ex, but they also have "gradient" attributes, so
#' that attr(evaluated expression,"gradient") is the gradient vector,
#' or a gradient matrix if the elements of x (say) are vectors.  Note that when this routine
#' returns a matrix as the gradient, this is not the df/dx matrix with f the ex vector.  It is
#' df(ix)/dx for a particular ix, evaluated at a vector of arguments.
#'
#' @md
#' @export
#' 
g0g1dc <- function(ex,x=attr(ex, "vlist"),xd=paste(x,"dot",sep=""),shock=attr(ex,"shock")){
  nf <- length(ex)
  g0g1out <- vector("expression",length(ex))
  for(ix in 1:nf){
    g0g1out[[ix]] <- deriv(ex[ix],c(xd,x,shock))
  }
    g0g1out <- structure(g0g1out, class="eqsys", names=names(ex), vlist=attr(ex, "vlist"), shock=attr(ex, "shock"), param=attr(ex, "param"), forward=attr(ex,"forward"))
  return(g0g1out)
}
