% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvarprior.R
\name{pvarprior}
\alias{pvarprior}
\title{Panel var prior}
\usage{
pvarprior(initcond, lags, sig, tight, decay, urtight, cointight,
  notrw = NULL, condOn = NULL)
}
\arguments{
\item{initcond}{list of lags by nv matrices of initial values, one for each
country.}

\item{sig}{vector of initial guesses for standard deviations of disturbances,
one for each variable in the system, or else a matrix, one column
per country.}

\item{tight}{The tightness of the prior on individual coefficients--- bigger
is tighter}

\item{decay}{Rate of harmonic decay in prior variances with lags.  0 is no
decay}

\item{urtight}{tightness of dummy observations that pull toward independent
martingales}

\item{cointight}{tightness of dummy observations that pull toward
cointegration and pull constant terms toward matching
initial condition sample means. This generates the prior on
the group-specific constants.}

\item{notrw}{logical vector, TRUE for variables that are not persistent, so
prior center is i.i.d., not random walk.  All FALSE by default.}

\item{condOn}{Which variables are treated as exogenous (entering X, but not Y).}
}
\value{
A list, indexed by country, of dummy variable `Y` and `X` matrices (a
        two-elment list for each country).  The list has a `priorpars`
        aattribute that lists all the prior parameters.
}
\description{
Create dummy observations for prior on reduced form in panel var model
}
\details{
Each country gets dummy observations.  The ones that apply only to
   coefficients that do not vary across countries (all except coint dummies)
   are weighted by the inverse of the square root of the number of countries.
   This prevents the prior from tightening automatically when the number of
   countries increases.  The X dummies have country-specific constants first,
   then the lagged variables that have constant coefficients across countries.
   Note that the X matrix has constants in the first columns.
}
