% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pSVARmdd.R
\name{pSVARmdd}
\alias{pSVARmdd}
\title{Panel structural VAR estimation}
\usage{
pSVARmdd(YX, A, lambda)
}
\arguments{
\item{YX}{The stacked `Y` and `X` data returned by [StackData()].}

\item{A}{The matrix of coefficients on contemporaneous variables in the SVAR.}

\item{lambda}{The matrix of scale factors for the structural shocks, which
vary across groups and across variables}
}
\value{
The list components returned are
\describe{
   \item{lmdd}{log marginal data density.}
   \item{mout}{Returned list from applying `mgls()` to all the data.}
   \item{priormout}{Returned list from applying `mgls` to prior dummy
      observations alone.}
   \item{lags}{Number of lags.}
   \item{dumspan}{Number of dummy observations in each group.}
   \item{call}{The function call that generated this output}
}
The returned list is of S3 class `psv`. The utilities [coef.psv()],
   [residuals.psv()], and [vcov.psv()] extract the more commonly used
   results in convenient form.
}
\description{
Returns marginal data density conditional on `A` and `lambda`
}
\details{
Using actual and dummy observations stacked in the first argument,
the `A` and `lambda` arguments are used to convert the system to a set of
weighted-data normal linear regression models.  The model is
\deqn{A(L) y_t = c_i \Lambda_i\epsilon_t,}
where \eqn{\epsilon} is \eqn{N(0,I)} and independent of past \eqn{y}.
The data are in groups \eqn{i} corresponding to, e.g., a country or a time
span.  They should be, within each group, a multiple time series object.
The  groups can be of different sizes.
}
\seealso{
[pvarprior()] (to set the prior conditional on `A` and `lambda`),
  [StackData()] (to combine the dummy observations from `pvarprior()` with the
  real data.
}
