% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgls.R
\name{mgls}
\alias{mgls}
\title{multivariate block GLS}
\usage{
mgls(Y, X, A = diag(dim(Y)[2]), lambda, breaks = NULL,
  verbose = FALSE)
}
\arguments{
\item{Y}{the dependent data matrix}

\item{X}{the right-hand side data matrix}

\item{A}{the matrix transformation that makes the errors independent across
equations}

\item{lambda}{the nv by ng (number of variables by number of groups) matrix,
each column of which scales the residuals in the corresponding group to
have unit variance}

\item{breaks}{the vector  of integers marking the ends of the groups as one
goes down the rows of X or Y}

\item{verbose}{If true, return key inputs as well as the outputs calculated
within the routine}
}
\value{
\describe{
\item{llh}{log likelihood conditional on \code{A,lambda}, maximized over
   \code{B}}
\item{lmdd}{log of marginal data density, i.e. posterior integrated over B}
\item{B}{matrix of regression coefficients, each column corresponding to one
   equation}
\item{uraw}{residuals that theoretically are i.i.d. N(0,1)}
\item{XR}{R piece of QR decomposition of X.  unless \code{breaks=NULL}, a
   list with one term for each variable}
}
}
\description{
Multiple left-hand sides, all transformed by A to structural form, weighted in blocks by `lambda`
}
\details{
Model is
\deqn{Y_i A \Lambda_i = X_i B + e_i}
where A is common across groups, \eqn{Y_i} and \eqn{X_i} are blocks of rows of Y and X corresponding
to group i, and \eqn{\Lambda_i} is a diagonal matrix.  The model assumes the e_i are N(0,I) and uncorrelated
across i.  If \code{breaks=NULL}, there is no group structure (i.e. just one group).  The names of
the columns of A propagate to name the columns of \code{uraw} and \code{B}  The \code{XR} returned
value is needed to form posterior variances of B.
}
