% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StackData.R
\name{StackData}
\alias{StackData}
\title{Construct Y and X matrices for VAR regression from a list of ts objects}
\usage{
StackData(realObs, dumObs = NULL, lags, condOn = NULL)
}
\arguments{
\item{realObs}{list of data time series (`mts`) objects, indexed by country name}

\item{dumObs}{list of dummy observation `Y` and `X` objects as produced by
`pvarprior`.}

\item{lags}{number of lags}

\item{condOn}{list of variables being conditioned on.}
}
\value{
\describe{
\item{Y,X} {left-hand-side and right-hand side matrices, including country constants
     and current and lagged values of variables conditioned on}
\item {tspReal}{Actual time span of data, including lags, for each country}
\item {countryEnds}{last row of Y,X for each country}
\item {lags}{number of lags}
\item {priorpars}{prior parameters passed through from dumObs attribute}
}
}
\description{
Model is a VAR, with some elements of \code{Y} possibly conditioned on, so treated
as exogenous.
}
\details{
The `ts` objects in the `realObs` list already have NAs removed from ends,
have been logged where necessary etc,  and contain just the desired set of 
variables. The dumObs list contains the already-formed dummy observations 
to implement the prior.
}
