#' Covariance matrix of coefficents for a panel SVAR
#'
#' The covariance matrix for the reduced form coefficients, conditional
#' on `A` and `lambda`.
#'
#' The covariance matrix of the right-hand-side coefficients in the SVAR,
#' conditional on `A` and `lambda`, is block diagonal, with the diagonal blocks
#' easily computable from psvout$mout$XR.
#'
#' @param psvout The `psv` object (returned by `sVARmdd()`)
#' 
vcov.psv <- function(psvout) {
    ## The covariance matrix (conditional on A and lambda) of  B / A,
    ## which is the reduced form coefficients.
    XR <- psvout$mout$XR
    if (!is.list(XR)) XR <- list(XR)
    nv <- length(XR)
    nx <- dim(XR[[1]])[1]
    vcv <- matrix(0, nv * nx, nv * nx)
    for (ic in 1:nv) {
        vcv [(ic - 1) * nx + 1:nx, (ic - 1) * nx + 1:nx] <- tcrossprod(solve(XR[[ic]]))
    }
    AI <- kronecker(t(solve(psvout$mout$A)), diag(nx))
    rfvcv <- AI %*% vcv %*% t(AI)
    return(rfvcv)
}
#' @export
#' @md
    

        
        
            
                     
