#' Extract residuals from a psv object
#'
#' Unstacks the structural residuals, returning a list indexed by country
#'
#' The model assumes these residuals are i.i.d. N(0,1).  Note that the last few
#' residuals in each country correspond to  prior dummy observations.  The
#' `dumspan` element of the return list is the number of dummy observations in each
#' country.
#'
residuals.psv <- function(psvout) {
    ur <- psvout$mout$uraw
    nc <- dim(psvout$mout$lambda)[2]
    ulist <- list()
    for (ic in 1:nc) ulist <- c(ulist, list(ur[(psvout$mout$breaks[ic] + 1):psvout$mout$breaks[ic+1], ]))
    names(ulist) <- names(psvout$mout$breaks)[-1]
    return(list(u=ulist, dumspan=psvout$dumspan))
}
#' @expport
#' @md

    
