#' pvarObj
#'
#' generate panel SVAR objective function so that data matrix not passed as
#' argument on each call.
#'
#' `YX` is big, and does not vary with the `lambda` and 
#' `A` parameters over which we optimize or sample.  Call this function to
#' return a minimand that has only the varying parameters as an argument
#'
#' @return `lmdd` is the posterior density integrated over the coefficients on
#' the right-hand side. To get draws of the right-hand side along with this,
#' just draw from the conditional density, which can be found from the returned
#' values in [mgls()] (or the `$mout` element returned from [pSVARmdd()]
#' @param YX a data object, incuding prior dummies, as returned by [StackData()]
#'
pvarObj <- function(YX) {
    pvarWrap <- function(alvec) {
        ## alvec has A, by column at start, first n columns of -log(lambda), by columns, next. last column
        ## of lambda  is nc  minus sum of first n-1, so overall sum is nc.
        ## 
        nv <- dim(YX$Y)[2]
        AL <- alvec2mat(alvec, nv)
        A <-  AL$A
        lambda <- AL$lambda
        nc <- length(YX$tspReal)
        if (any( lambda <= 0 )) {
            return ( 1e20 )             #i.e. really bad, since we're minimizing
        } else {
            lpA <- -.5 * sum((A - diag(nv) * 100)^2) / 4e4 - nv^2 * (log(2 * pi) / 2 - nv^2 * log(200))
            ## i.e., i.i.d. N(100,200^2) on diagonal, N(0,200^2) off diagonal
            lpL <- apply(log(lambda/nc), 1, sum) - lgamma(2 * nc)  #log of (dirichlet(c(2,2,,...)) density,
            ## modes are at equal lambda's across countries, but fairly flat.  Each row is a dirichlet
            ## multiplied by nc, according to the prior.
            ## could try other dirichlet above.
            lpL <- sum(lpL) - nv*(nc - 1) * log(nc)
            ## nc terms account for scaling up of the dirichlet so sum is nc rather than one.
            pout <- pSVARmdd(YX, A, lambda)
            lmdd <- pout$lmdd + lpL + lpA
            lmdd <- -lmdd                       #For minimization Account for this when making posterir draws.
            return( lmdd )
        }
    }
    return(pvarWrap)
}
#' @export
#' @md
