pvarMCMC <- function(startx, jumpH, postFunc, draws, printfreq=10, delta=.01) {
    nx <- length(startx)
    xold <- startx
    drawmat <- matrix(0, draws, nx )
    llhdraws <- vector("numeric", draws)
    shockmat <- matrix(rnorm(draws * nx), draws, nx)
    deciders <- runif(draws)
    llhold <- -postFunc(xold)           #neg sign since fcn used in minimization
    accrate <- 1
    for (id in 1:draws) {
        drawmat[id, ] <- xold
        llhdraws[id] <- llhold
        ## so jumpH might be some scale-down of chol(H from csminselNew)
        xnew <- xold + shockmat[id, ] %*% jumpH
        llhnew <- -postFunc(xnew)
        if (exp(llhnew - llhold) > deciders[id]) {
            xold <- xnew
            llhold <- llhnew
            acc <- 1
        } else {
            acc <- 0
        }
        accrate <- delta*acc + (1 - delta) * accrate
        if (id %% printfreq == 0) print(paste("id =", id, "accrate =", accrate, ",  llh =", llhold))
    }
    return(list(drawmat=drawmat, llhdraws=llhdraws))
}

