#' coef.psv
#'
#' Extract coefficients from `pSVARmdd()` output.
#' 
#' The psv class is what [pSVARmdd()] returns as output.  So this function
#' can be invoked just by `coef(psvout)`.  It returns an array of AR
#' coefficient matrices as `By`, as well as the array of group-specific
#' constant terms as `ci`.
#'
#' @export
#' @md
coef.psv <- function(psvout) {
    rfb <- solve(t(psvout$mout$A), t(psvout$mout$B) )
    nx <- dim(psvout$mout$B)[1]
    nv <- dim(psvout$mout$B)[2]
    lags <- psvout$lags
    nBy <- nv^2 * lags
    nc <- nx - nv * lags
    ci <- rfb[ , 1:nc, drop=FALSE]
    By <- array(rfb[ , (nc+1):nx], c(nv, nv, lags))
    return(list(ci=ci, By=By))
}

    
    
