#' Convert vectorized `A` and `lambda` to matrix form.
#'
#' @details For optimization, `A` and `lambda` are packed into a single vector, and
#' the normalization that requires the sum of each row of `lambda` to be `nv`
#' allows reducing the length of the vector.  This function returns `A` and `lambda`
#' as matrices.
#' @param alvec The vectorized parameters.
#' @param nv Number of variables.
#'
#' @seealso [Alambda2vec()]
#' 
alvec2mat <- function(alvec, nv) {
    A <- matrix(alvec, nrow=nv)
    nc <- ncol(A) - nv + 1
    lambda <- A[ , nv + 1:(nc - 1), drop=FALSE]
    A <- A[ , 1:nv, drop=FALSE]
    lambda <- cbind(lambda, nc - apply(lambda, 1, sum))
    return(list(A=A, lambda=lambda))
}
#' 
#' @export
#' @md
