#' Pull data from list of country data 
#'
#' Data pulled to match a variable list and time span, with countries
#' that don't have a variable dropped and years that a country doesn't
#' have data dropped. Each country also checked for mid-sample NA values.
#' Logging, differencing, etc done afterwards by some other program.
#'
#' @param dataTS list of time series of data, indexed by country
#' @param countries vector of country names, if the list is to be restricted
#' @param variables vector of variable names (required)
#' @param tspList \code{tsp} attributes to be applied to each country, if
#'                they are to be restricted
#' @return a list of mts objects, each of which has no missing values. For
#'         countries with "internal" na's, there will be multiple list elements
#'         with the same (country) name.
ExtractData <- function(dataTS, countries=NULL, variables, tspList=NULL) {
    if (is.null(countries)) countries <- names(dataTS)
    if (is.null(tspList)) tspList <- lapply(dataTS, tsp)
    nc <- length(countries)
    outdata <- vector("list",0)
    outnames <- vector("character",0)
    for (ic in 1:nc) {
        if (all(variables %in% dimnames(dataTS[[ic]])[[2]])) {
            out <- dataTS[[countries[ic]]][ , variables]
            out <- window(out, tspList[[ic]][1], tspList[[ic]][2])
            spout <- spans(out)
            if (!is.null(spout)) {
                nsp <- dim(spout)[1]
                for (isp in 1:nsp) {
                    outdata <- c(outdata,list(window(out, start=spout[isp,1], end=spout[isp,2])))
                    outnames <- c(outnames, countries[ic])
                }
            }
        }
    }
    names(outdata) <- outnames
    outcountries <- unique(outnames)
    return(list(data=outdata, countrynames=outcountries))
}
#' @export

                
        
    
        
