#' Pack `A` and `lambda` into a single parameter vector
#'
#' Used with an optimization program that has a vector argument
#'
#' @seealso [alvec2lambda()].
Alambda2vec <-  function(A, lambda) {
    nc <- ncol(lambda)
    lrowsum <- apply(lambda, 1, sum)
    if (any( abs(lrowsum - nc) > 1e-8 )) {
        A <- A %*% diag(lrowsum)/nc
        lambda <- (nc/lrowsum) * lambda
    }
    alvec <- c(A, lambda[ , -ncol(lambda)])
}
#' @export
#' @md
